//---------------------------------------------------------------------------
//
//    FCST: Fuel Cell Simulation Toolbox
//
//    Copyright (C) 2013 by Energy Systems Design Laboratory, University of Alberta
//
//    This software is distributed under the MIT License.
//    For more information, see the README file in /doc/LICENSE
//
//    - Class:  fcst_units.h
//    - Description: A class consisting of static members that can be used by OpenFCST 
//          programmers when manipulating units in order to preserve
//          standards and prevent confusion.
//    - Developers: Philip Wardlaw and M. Secanell
//
//---------------------------------------------------------------------------

#include "utils/fcst_units.h"

double Units::PER_K_UNIT = 1.0E3;
double Units::PER_UNIT =  1;
double Units::PER_C_UNIT =  1E-2;
double Units::PER_MILLI_UNIT =  1E-3;
double Units::PER_MICRO_UNIT =  1E-6;
double Units::PER_N_UNIT =  1E-9;
double Units::PER_P_UNIT =  1E-12;
	
double Units::PER_UNIT2 =  1;
double Units::PER_C_UNIT2 =  1E-4;
double Units::PER_MILLI_UNIT2 =  1E-6;
double Units::PER_MICRO_UNIT2 =  1E-12;
double Units::PER_N_UNIT2 =  1E-18;
double Units::PER_P_UNIT2 =  1E-24;
	
double Units::PER_UNIT3 =  1;
double Units::PER_C_UNIT3 =  1E-6;
double Units::PER_MILLI_UNIT3 =  1E-9;
double Units::PER_MICRO_UNIT3 =  1E-18;
double Units::PER_N_UNIT3 =  1E-27;
double Units::PER_P_UNIT3 =  1E-36;

double Units::K_UNIT = -1.0E3;
double Units::UNIT =  -1;
double Units::C_UNIT = - 1E-2;
double Units::MILLI_UNIT =  -1E-3;
double Units::MICRO_UNIT = - 1E-6;
double Units::N_UNIT =-  1E-9;
double Units::P_UNIT =  -1E-12;
	
double Units::UNIT2 = - 1;
double Units::C_UNIT2 =  -1E-4;
double Units::MILLI_UNIT2 =  -1E-6;
double Units::MICRO_UNIT2 = - 1E-12;
double Units::N_UNIT2 =  -1E-18;
double Units::P_UNIT2 =  -1E-24;
	
double Units::UNIT3 = - 1;
double Units::C_UNIT3 =  -1E-6;
double Units::MILLI_UNIT3 = - 1E-9;
double Units::MICRO_UNIT3 = - 1E-18;
double Units::N_UNIT3 = - 1E-27;
double Units::P_UNIT3 = - 1E-36;