#!/bin/bash

# This command finds location of the script
# from which it is called
BASEDIR=$(dirname $0)

# IMPORTANT: $BASEDIR will return "." if script
# is run from the same folder in which it resides.
# Since this script is always run from another
# directory, we are fine.

# Extract environmental variables
source $BASEDIR/Install/fcst_env.sh

# The following system variables must be set.
# They are typically native to the konsole
# environment but not the cron environment.
PATH=/usr/NX/bin:/usr/lib64/mpi/gcc/openmpi/bin:/home/cdash/bin:/usr/local/bin:/usr/bin:/bin:/usr/bin/X11:/usr/X11R6/bin:/usr/games:/opt/kde3/bin:/usr/lib/mit/bin
LD_LIBRARY_PATH=/usr/lib64/mpi/gcc/openmpi/lib64
export PATH
export LD_LIBRARY_PATH


echo "--------------------------------------------"
echo "-------------Starting CTEST-----------------"
echo "--------------------------------------------"

########################################################
###### Here we check if /Build/ folder exists and ######
######## delete it to always use a fresh build #########
########################################################

cd $BASEDIR
if [ -d Build ]; then
  rm -rf Build
fi

########################################################
################ Run tests using CTest #################
########################################################

ctest -S nightly_tests.cmake
