# -----------------------------------------------------------  
# -- Get environment
# -----------------------------------------------------------  

## -- Set hostname
## --------------------------
find_program(HOSTNAME_CMD NAMES hostname)
exec_program(${HOSTNAME_CMD} ARGS OUTPUT_VARIABLE HOSTNAME)

#Name of this computer
set(CTEST_SITE                          "${HOSTNAME}")

## -- Set site / build name
## --------------------------

find_program(UNAME NAMES uname)
macro(getuname name flag)
  exec_program("${UNAME}" ARGS "${flag}" OUTPUT_VARIABLE "${name}")
endmacro(getuname)

getuname(osname -s)
getuname(osrel  -r)
getuname(cpu    -m)


set(MODEL                               "Nightly")

## -- SVN command
## ----------------
find_program(CTEST_GIT_COMMAND NAMES git)

## -- make command
## -----------------
find_program(MAKE NAMES make)

# -----------------------------------------------------------  
# -- build specificFCST
# -----------------------------------------------------------  

## -- DashBoard Root
set(CTEST_DASHBOARD_ROOT                 ${CMAKE_CURRENT_LIST_DIR})

## -- SRC Dir
set(CTEST_SOURCE_DIRECTORY              "${CTEST_DASHBOARD_ROOT}/Install/test")

## -- BIN Dir                                            
set(CTEST_BINARY_DIRECTORY              "${CTEST_SOURCE_DIRECTORY}/build-${CTEST_BUILD_NAME}") 

## -- Build options
##set(OPTION_BUILD                        "-j16")

# -----------------------------------------------------------  
# -- commands
# -----------------------------------------------------------  

## -- Update Command
set(CTEST_UPDATE_COMMAND               "${CTEST_GIT_COMMAND}")

## -- Configure Command
#set(CTEST_CONFIGURE_COMMAND            "./openFCST_install ") #We don't really have a configure command...


# -----------------------------------------------------------  
# -- Configure CTest
# -----------------------------------------------------------  

## -- read CTestCustom.cmake file
ctest_read_custom_files("${CTEST_SOURCE_DIRECTORY}")

# -----------------------------------------------------------  
# -- Settings
# -----------------------------------------------------------  

## -- Process timeout in seconds
set(CTEST_TEST_TIMEOUT           "14400")

## -- Set output to english
set( $ENV{LC_MESSAGES}      "en_EN" )

# -----------------------------------------------------------  
# -- Run CTest
# -----------------------------------------------------------  

##----Remove comments made using a single hash key in order to
##----get CTest to test that component.

 ##############################################################
 ######################                  ######################
 ###################### Testing sequence ######################
 ######################                  ######################
 ############################################################## 
 
 set(GIT_BRANCHES "development" "master") 
 set(BUILD_MODES "release" "debug")
 set(BUILD_FLAGS "dakota" "petsc")
 set(DISTR_NAME "openSUSE_13.1")
  
 ## WRITE: -- First, turn all options off.

 file(WRITE ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "List of current build flags:" "\n")
 file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "--cores=" "\n") 					# Set flag for number of cores
 file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "6" "\n") 						# Set number of cores
 file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "PETScOFF" "\n") 					# Turn PETSc option off
 file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "DAKOTAOFF" "\n") 					# Turn Dakota option off

 ## WRITE: -- End
 
 FOREACH(GIT_BRANCH ${GIT_BRANCHES})
 
 FOREACH(BUILD_FLAG ${BUILD_FLAGS})
 
   IF(GIT_BRANCH STREQUAL "master")

   set(BUILD_MODE "release")
      
      IF(BUILD_FLAG STREQUAL "dakota")
	file(WRITE ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "List of current build flags:" "\n")
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "--cores=" "\n") 					# Set flag for number of cores
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "6" "\n") 						# Set number of cores	
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "PETScOFF" "\n") 				# This option will be read by CTestTestfile.cmake
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "DAKOTAON" "\n") 				# This option will be read by CTestTestfile.cmake
        set(CTEST_BUILD_COMMAND	"./openFCST_install --cores=6  --with-dakota")
      ELSEIF(BUILD_FLAG STREQUAL "petsc")
        file(WRITE ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "List of current build flags:" "\n")
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "--cores=" "\n") 					# Set flag for number of cores
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "6" "\n") 						# Set number of cores	        
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "PETScON" "\n") 				# This option will be read by CTestTestfile.cmake
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "DAKOTAOFF" "\n") 				# This option will be read by CTestTestfile.cmake
        set(CTEST_BUILD_COMMAND	"./openFCST_install --cores=6  --with-petsc")
      ENDIF()
    
       ## -- Checkout the branch
      execute_process (COMMAND ${CTEST_GIT_COMMAND} checkout ${GIT_BRANCH})
      set(CTEST_BUILD_NAME                    "${DISTR_NAME}-${osname}-${cpu}-${GIT_BRANCH}-${BUILD_MODE}-${BUILD_FLAG}")
  
  
      message(" -- Start dashboard ${MODEL} - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} - ${BUILD_MODE} - ${BUILD_FLAG} --")
      ctest_start(${MODEL} TRACK ${MODEL})
  
      ## -- Update
      message(" -- Update ${MODEL} - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} - ${BUILD_MODE} -${BUILD_FLAG} --")
      ctest_update(           SOURCE "${CTEST_DASHBOARD_ROOT}" RETURN_VALUE res)
  
     ## -- Configure, which we do not utilize due to the nature of OpenFCST
     ##message(" -- Configure ${MODEL} - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} --")
     ##ctest_configure(BUILD  "${CTEST_DASHBOARD_ROOT}" RETURN_VALUE res)
 
     # -- BUILD, build the whole project
     message(" -- Build ${MODEL} - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} - ${BUILD_MODE} -${BUILD_FLAG} --")
     ctest_build(    BUILD  "${CTEST_DASHBOARD_ROOT}" RETURN_VALUE res)
 
     ## -- TEST
     message(" -- Test ${MODEL} - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} -${BUILD_MODE} -${BUILD_FLAG} --")
     ctest_test(     BUILD  "${CTEST_SOURCE_DIRECTORY}" RETURN_VALUE res)
 
     ## -- SUBMIT
     message(" -- Submit ${MODEL} - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} -${BUILD_MODE} -${BUILD_FLAG} --")
     ctest_submit(                                              RETURN_VALUE res)
 
     message(" -- Finished ${MODEL}  - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} -${BUILD_MODE} -${BUILD_FLAG} --")
   
   ELSEIF(GIT_BRANCH STREQUAL "development")
     
     FOREACH(BUILD_MODE ${BUILD_MODES})
     
       IF(BUILD_FLAG STREQUAL "dakota")

        file(WRITE ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "List of current build flags:" "\n")
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "--cores=" "\n") 					# Set flag for number of cores
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "6" "\n") 						# Set number of cores	        
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "PETScOFF" "\n") 		 		# This option will be read by CTestTestfile.cmake
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "DAKOTAON" "\n") 				# This option will be read by CTestTestfile.cmake
       
 	IF(BUILD_MODE STREQUAL "release")
 	  set(CTEST_BUILD_COMMAND        "./openFCST_install --cores=6  --with-dakota")
 	ELSEIF(BUILD_MODE STREQUAL "debug")
 	  set(CTEST_BUILD_COMMAND        "./openFCST_install --cores=6  --with-dakota --openfcst-debug")
 	ENDIF()
 	
       ELSEIF(BUILD_FLAG STREQUAL "petsc")
       
        file(WRITE ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "List of current build flags:" "\n")
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "--cores=" "\n") 					# Set flag for number of cores
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "6" "\n") 						# Set number of cores	        
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "PETScON" "\n") 		 		# This option will be read by CTestTestfile.cmake
	file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "DAKOTAOFF" "\n") 				# This option will be read by CTestTestfile.cmake
       
 	IF(BUILD_MODE STREQUAL "release")
 	  set(CTEST_BUILD_COMMAND        "./openFCST_install --cores=6  --with-petsc")
 	ELSEIF(BUILD_MODE STREQUAL "debug")
 	  set(CTEST_BUILD_COMMAND        "./openFCST_install --cores=6  --with-petsc --openfcst-debug")
 	ENDIF()
 	
       ENDIF()
       
       ## -- Checkout the branch
     execute_process (COMMAND ${CTEST_GIT_COMMAND} checkout ${GIT_BRANCH})
     set(CTEST_BUILD_NAME                    "${DISTR_NAME}-${osname}-${cpu}-${GIT_BRANCH}-${BUILD_MODE}-${BUILD_FLAG}")
 
     message(" -- Start dashboard ${MODEL} - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} - ${BUILD_MODE} - ${BUILD_FLAG} --")
     ctest_start(${MODEL} TRACK ${MODEL})
 
     ## -- Update
     message(" -- Update ${MODEL} - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} - ${BUILD_MODE} -${BUILD_FLAG} --")
     ctest_update(           SOURCE "${CTEST_DASHBOARD_ROOT}" RETURN_VALUE res)
 
     ## -- Configure, which we do not utilize due to the nature of OpenFCST
     ##message(" -- Configure ${MODEL} - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} --")
     ##ctest_configure(BUILD  "${CTEST_DASHBOARD_ROOT}" RETURN_VALUE res)
 
     # -- BUILD, build the whole project
     message(" -- Build ${MODEL} - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} - ${BUILD_MODE} -${BUILD_FLAG} --")
     ctest_build(    BUILD  "${CTEST_DASHBOARD_ROOT}" RETURN_VALUE res)
 
     ## -- TEST
     message(" -- Test ${MODEL} - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} -${BUILD_MODE} -${BUILD_FLAG} --")
     ctest_test(     BUILD  "${CTEST_SOURCE_DIRECTORY}" RETURN_VALUE res)
 
     ## -- SUBMIT
     message(" -- Submit ${MODEL} - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} -${BUILD_MODE} -${BUILD_FLAG} --")
     ctest_submit(                                              RETURN_VALUE res)
 
     message(" -- Finished ${MODEL}  - ${GIT_BRANCH} - ${CTEST_BUILD_NAME} -${BUILD_MODE} -${BUILD_FLAG} --")
       
     ENDFOREACH()  
   ENDIF()
 
 ENDFOREACH() # BUILD_FLAG
 
    file(WRITE ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "List of current build flags:" "\n") # Rewrite the file
    file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "--cores=" "\n") 					# Set flag for number of cores
    file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "6" "\n") 						# Set number of cores	    
    file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "PETScOFF" "\n") # Turn PETSc option off
    file(APPEND ${CTEST_DASHBOARD_ROOT}/Install/test/config.txt "DAKOTAOFF" "\n") # Turn Dakota option off
 
 ENDFOREACH() # GIT_BRANCH
